﻿using System;
using System.Configuration;
using System.Net;
using System.Threading;
using ClientDemo.Utils;
using gov.va.med.VBECS.Communication.Clients;
using gov.va.med.VBECS.Communication.Common;

namespace ClientDemo.Demos
{
    public class SimpleLoop : ClientDemoBase
    {
        public override void Start()
        {
            //Read server IP address/ Port
            var serverIp = ConfigurationManager.AppSettings.Get("ServerIP");
            var serverPort = ConfigurationManager.AppSettings.Get("ServerPort");
            var msgTimeout = int.Parse(ConfigurationManager.AppSettings.Get("MsgTimeout"));

            Console.WriteLine("Press enter to connect to the server: " + serverIp + ":" + serverPort);
            Console.ReadLine(); //Wait user to press enter
            
            using (var client = ClientFactory.CreateClient<MockPinger>(new IPEndPoint(IPAddress.Parse(serverIp), int.Parse(serverPort))))
            {
                client.Connect();
                client.MessageReceived -= client_message_received;
                client.MessageReceived += client_message_received;
                //read a test message
                var message = new FileMessageFactory().ReadMesage("InputMessage");
                if (message == null)
                {
                    return;
                }

                Console.WriteLine("\n\rPress Escape to disconnect from server or C to send again");

                while (true)
                {
                    client.Send(message);

                    Thread.Sleep(msgTimeout);
                    //var key = Console.ReadKey(true).Key;
                    //if (key == ConsoleKey.C) break;
                    //if (key == ConsoleKey.Escape) break;
                }
            }
        }

        static void client_message_received(object sender, MessageEventArgs e)
        {
            var message = e.Message as TextMessage; //Server only accepts text messages
            if (message == null && e.Message is RawDataMessage)
            {
                // Try to construct message from RawMessage
                message = new TextMessage(((RawDataMessage)e.Message).Data);
            }
            if (message == null) return;

            Console.WriteLine("Response from messager: " + message.Text);
        }

    }
}
